<?php

namespace Drupal\api_connection\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;
use Drupal\api_connection\ApiConnectionEnvironmentInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Settings form for the API Connection module.
 */
class ApiConnectionSettingsForm extends ConfigFormBase {

  use RedundantEditableConfigNamesTrait;

  /**
   * ApiConnectionSettingsForm constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The factory for configuration objects.
   * @param \Drupal\Core\Config\TypedConfigManagerInterface $typedConfigManager
   *   The typed config manager.
   * @param \Drupal\api_connection\ApiConnectionEnvironmentInterface $apiConnectionEnvironment
   *   The API Connection environment service.
   */
  public function __construct(
    ConfigFactoryInterface $config_factory,
    TypedConfigManagerInterface $typedConfigManager,
    protected readonly ApiConnectionEnvironmentInterface $apiConnectionEnvironment,
  ) {
    parent::__construct($config_factory, $typedConfigManager);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('config.typed'),
      $container->get('api_connection.environment')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'api_connection_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['enable_logging'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable logging'),
      '#description' => $this->t('Enable API call logging'),
      '#config_target' => 'api_connection.settings:enable_logging',
    ];

    $form['environment'] = [
      '#type' => 'radios',
      '#title' => $this->t('Environment'),
      '#description' => $this->t('Specify the current environment'),
      '#config_target' => 'api_connection.settings:environment',
      '#options' => $this->apiConnectionEnvironment->getEnvironments(),
      '#required' => TRUE,
    ];
    return parent::buildForm($form, $form_state);
  }

}
