<?php

namespace Drupal\api_plugins\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines an API plugin annotation object.
 *
 * Plugin Namespace: Plugin\ApiPlugin.
 *
 * @see \Drupal\api_plugins\ApiRequestService
 * @see plugin_api
 *
 * @Annotation
 */
class ApiPlugin extends Plugin {

  /**
   * The unique plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the API plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A short description of the API plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The type of API (ai, rest, graphql, soap, mcp, xml).
   *
   * @var string
   */
  public $type;

  /**
   * The base endpoint URL of the API.
   *
   * @var string
   */
  public $endpointUrl;

  /**
   * Optional default configuration for the plugin.
   *
   * @var array<string, mixed>
   */
  public $defaultConfig = [];

}
