<?php

namespace Drupal\api_plugins;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Provides an Archiver plugin manager.
 *
 * @see \Drupal\api_plugins\Annotation\ApiPlugin
 * @see \Drupal\api_plugins\ApiPluginInterface
 * @see plugin_api
 */
class ApiPluginDiscovery extends DefaultPluginManager {

  /**
   * Constructs an ArchiverManager object.
   *
   * @param iterable $namespaces
   *   An iterable that contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(iterable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/ApiPlugin', $namespaces, $module_handler, 'Drupal\api_plugins\ApiPluginInterface', 'Drupal\api_plugins\Annotation\ApiPlugin');
    $this->alterInfo('api_plugins_plugin_definitions');
    $this->setCacheBackend($cache_backend, 'api_plugins_info_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function getDefinitions() {
    $definitions = parent::getDefinitions();
    $this->moduleHandler->alter('api_plugins_plugin_definitions', $definitions);
    return $definitions;
  }

}
