<?php

namespace Drupal\api_plugins\Exception;

/**
 * Exception thrown when API authentication fails.
 *
 * This exception is thrown when there are authentication or authorization
 * issues with an API (401, 403 errors).
 *
 * @package Drupal\api_plugins\Exception
 */
class ApiAuthenticationException extends \RuntimeException {

  /**
   * The provider that failed authentication.
   *
   * @var string
   */
  protected $provider;

  /**
   * Constructs an ApiAuthenticationException.
   *
   * @param string $message
   *   The exception message.
   * @param string $provider
   *   The provider that failed authentication.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception.
   */
  public function __construct(string $message = '', string $provider = '', int $code = 0, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);
    $this->provider = $provider;
  }

  /**
   * Gets the provider that failed authentication.
   *
   * @return string
   *   The provider name.
   */
  public function getProvider(): string {
    return $this->provider;
  }

}
