<?php

namespace Drupal\api_plugins\Exception;

/**
 * Exception thrown when API configuration is invalid or missing.
 *
 * This exception should be used for:
 * - Missing or invalid API keys
 * - Invalid endpoint configuration
 * - Missing required configuration parameters
 * - Invalid authentication settings.
 */
class ApiConfigurationException extends \RuntimeException {

  /**
   * The plugin ID that triggered the exception.
   *
   * @var string|null
   */
  protected ?string $pluginId = NULL;

  /**
   * Constructs an ApiConfigurationException.
   *
   * @param string $message
   *   The exception message.
   * @param string|null $plugin_id
   *   The plugin ID that triggered the exception.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception.
   */
  public function __construct(string $message = '', ?string $plugin_id = NULL, int $code = 0, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);
    $this->pluginId = $plugin_id;
  }

  /**
   * Gets the plugin ID that triggered this exception.
   *
   * @return string|null
   *   The plugin ID, or NULL if not set.
   */
  public function getPluginId(): ?string {
    return $this->pluginId;
  }

}
