<?php

namespace Drupal\api_plugins\Exception;

/**
 * Exception thrown when API connection fails.
 *
 * This exception is thrown when there are network-level issues
 * connecting to an API endpoint.
 *
 * @package Drupal\api_plugins\Exception
 */
class ApiConnectionException extends \RuntimeException {

  /**
   * The API endpoint that failed.
   *
   * @var string
   */
  protected $endpoint;

  /**
   * Constructs an ApiConnectionException.
   *
   * @param string $message
   *   The exception message.
   * @param string $endpoint
   *   The API endpoint that failed.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception.
   */
  public function __construct(string $message = '', string $endpoint = '', int $code = 0, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);
    $this->endpoint = $endpoint;
  }

  /**
   * Gets the API endpoint that failed.
   *
   * @return string
   *   The API endpoint.
   */
  public function getEndpoint(): string {
    return $this->endpoint;
  }

}
