<?php

namespace Drupal\api_plugins\Exception;

/**
 * Exception thrown when API rate limit is exceeded.
 *
 * This exception is thrown when the API returns a 429 Too Many Requests
 * status code or when local rate limiting is triggered.
 *
 * @package Drupal\api_plugins\Exception
 */
class ApiRateLimitException extends \RuntimeException {

  /**
   * The number of seconds to wait before retrying.
   *
   * @var int
   */
  protected $retryAfter;

  /**
   * Constructs an ApiRateLimitException.
   *
   * @param string $message
   *   The exception message.
   * @param int $retry_after
   *   The number of seconds to wait before retrying.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception.
   */
  public function __construct(string $message = '', int $retry_after = 0, int $code = 429, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);
    $this->retryAfter = $retry_after;
  }

  /**
   * Gets the number of seconds to wait before retrying.
   *
   * @return int
   *   The retry-after value in seconds.
   */
  public function getRetryAfter(): int {
    return $this->retryAfter;
  }

}
