<?php

namespace Drupal\api_plugins\Exception;

/**
 * Exception thrown when API response is invalid or cannot be parsed.
 *
 * This exception should be used for:
 * - Invalid API response format.
 * - Failed API requests (HTTP errors)
 * - Response parsing errors.
 * - Unexpected API behavior.
 */
class ApiResponseException extends \RuntimeException {

  /**
   * The HTTP status code, if applicable.
   *
   * @var int|null
   */
  protected ?int $statusCode = NULL;

  /**
   * The raw response data, if available.
   *
   * @var mixed
   */
  protected mixed $responseData = NULL;

  /**
   * Constructs an ApiResponseException.
   *
   * @param string $message
   *   The exception message.
   * @param int $code
   *   The exception code.
   * @param int|null $status_code
   *   The HTTP status code.
   * @param mixed $response_data
   *   The raw response data.
   * @param \Throwable|null $previous
   *   The previous exception.
   */
  public function __construct(string $message = '', int $code = 0, ?int $status_code = NULL, mixed $response_data = NULL, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);
    $this->statusCode = $status_code;
    $this->responseData = $response_data;
  }

  /**
   * Gets the HTTP status code.
   *
   * @return int|null
   *   The HTTP status code, or NULL if not set.
   */
  public function getStatusCode(): ?int {
    return $this->statusCode;
  }

  /**
   * Gets the raw response data.
   *
   * @return mixed
   *   The raw response data.
   */
  public function getResponseData(): mixed {
    return $this->responseData;
  }

}
