<?php

namespace Drupal\api_plugins\Exception;

/**
 * Exception thrown when API request times out.
 *
 * This exception is thrown when an API request exceeds the configured
 * timeout period.
 *
 * @package Drupal\api_plugins\Exception
 */
class ApiTimeoutException extends \RuntimeException {

  /**
   * The timeout value in seconds.
   *
   * @var int
   */
  protected $timeout;

  /**
   * Constructs an ApiTimeoutException.
   *
   * @param string $message
   *   The exception message.
   * @param int $timeout
   *   The timeout value in seconds.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception.
   */
  public function __construct(string $message = '', int $timeout = 0, int $code = 0, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);
    $this->timeout = $timeout;
  }

  /**
   * Gets the timeout value.
   *
   * @return int
   *   The timeout in seconds.
   */
  public function getTimeout(): int {
    return $this->timeout;
  }

}
