<?php

namespace Drupal\api_status;

/**
 * Interface for the API Status service.
 */
interface ApiStatusServiceInterface {

  /**
   * Logs an API call status.
   *
   * @param string $api_key
   *   The unique API identifier (e.g., 'stripe_payment', 'sendgrid_email').
   * @param string $status
   *   The status: 'success' or 'failed'.
   * @param string|null $endpoint
   *   Optional. The API endpoint/path.
   *
   * @return bool
   *   TRUE if logged successfully.
   */
  public function log(string $api_key, string $status, ?string $endpoint = NULL): bool;

  /**
   * Gets the status of a specific API.
   *
   * @param string $api_key
   *   The unique API identifier.
   *
   * @return array
   *   Array with keys: last_success, last_failed, current_status, endpoint.
   */
  public function getStatus(string $api_key): array;

  /**
   * Gets status of all tracked APIs.
   *
   * @return array
   *   Array keyed by API key, each containing status info.
   */
  public function getAllStatuses(): array;

  /**
   * Clears status for a specific API.
   *
   * @param string $api_key
   *   The API key to clear.
   */
  public function clear(string $api_key): void;

  /**
   * Clears all API status data.
   */
  public function clearAll(): void;

}

