# Headless API Token

## 📋 Introduction

This module offers a back‑office interface for managing API tokens—creation, rotation, and deletion, plus a service to validate issued tokens.

---

## 📦 Requirements

- Drupal ^11.3
- PHP 8.4+
- Composer 2.x

---

## 🛠️ Usage

**Install the module via Composer:**

```shell
composer require drupal/api_token_entity
```

Then navigate to _Drupal admin menu > Configuration > Web services > API token entity_ and create some API tokens.

**Use case - route access check:**

```yaml
mymodule.main:
  path: '/api/main'
  defaults:
    _form: 'Drupal\mymodule\Controller\MyModuleController::main'
    _title: 'Main'
  requirements:
    _api_token_type: 'my_token_type.read_only' # Check token type.
    _api_token: 'my_token_type.read_only:alice' # Check token type and consumer.
```

**Use case - use directly through manager class:**
```php
$token_name = \Drupal::service('api_token_entity.api_token.manager')->checkApiToken($token_value, 'my_token_type.read_only', self::class)
if (empty($token_name)) {
  // Stop: invalid token
}
// Continue: valid token
```

---

## 🔩 Developing this module

**Set up:**
```shell
# Get Drupal dev dependencies
ddev composer require --dev drupal/core-dev:"^11.3" -W

# Install Selenium's ChromeDriver
ddev get ddev/ddev-selenium-standalone-chrome
```

**Validations & Tests:**
```shell
# PhpStan
ddev exec vendor/bin/phpstan analyze -c web/modules/custom/api_token_entity/phpstan.neon web/modules/custom/api_token_entity

# PHPCS
ddev exec vendor/bin/phpcs --standard=web/modules/custom/api_token_entity/phpcs.xml web/modules/custom/api_token_entity

# PHPUnit
ddev exec env SIMPLETEST_BASE_URL=http://web vendor/bin/phpunit -c web/core --stop-on-failure web/modules/custom/api_token_entity/tests/src/Functional
```

---

## 🧑‍💻 Maintainers

- deviktta@protonmail.com
