<?php

namespace Drupal\api_token_entity\Entity;

use Drupal\api_token_entity\ApiTokenTypeInterface;
use Drupal\Core\Entity\Attribute\ContentEntityType;
use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\EntityViewBuilder;
use Drupal\Core\Entity\Form\DeleteMultipleForm;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\Core\Entity\Sql\SqlContentEntityStorageSchema;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\api_token_entity\ApiTokenEntityAccessControlHandler;
use Drupal\api_token_entity\ApiTokenTypeListBuilder;
use Drupal\views\EntityViewsData;

/**
 * Defines the API token type entity class.
 */
#[ContentEntityType(
  id: 'api_token_entity_api_token_type',
  label: new TranslatableMarkup('API token type'),
  label_collection: new TranslatableMarkup('API token types'),
  label_singular: new TranslatableMarkup('API token type'),
  label_plural: new TranslatableMarkup('API token types'),
  entity_keys: [
    'id' => 'id',
    'label' => 'name',
  ],
  handlers: [
    'route_provider' => [
      'html' => AdminHtmlRouteProvider::class,
    ],
    'storage' => SqlContentEntityStorage::class,
    'storage_schema' => SqlContentEntityStorageSchema::class,
    'view_builder' => EntityViewBuilder::class,
    'access' => ApiTokenEntityAccessControlHandler::class,
    'views_data' => EntityViewsData::class,
    'form' => [
      'default' => ContentEntityForm::class,
      'delete' => ContentEntityDeleteForm::class,
      'edit' => ContentEntityForm::class,
      'delete-multiple-confirm' => DeleteMultipleForm::class,
    ],
    'list_builder' => ApiTokenTypeListBuilder::class,
  ],
  links: [
    'delete-form' => '/admin/config/services/api-token-entity/api-token-type/{api_token_entity_api_token_type}/delete',
    'delete-multiple-form' => '/admin/config/services/api-token-entity/api-token-type/delete',
    'add-form' => '/admin/config/services/api-token-entity/api-token-type/add',
    'edit-form' => '/admin/config/services/api-token-entity/api-token-type/{api_token_entity_api_token_type}/edit',
    'collection' => '/admin/config/services/api-token-entity/api-token-type/list',
  ],
  admin_permission: 'administer api_token_entity entities',
  collection_permission: 'administer api_token_entity entities',
  base_table: 'api_token_entity_api_token_type',
  data_table: 'api_token_entity_api_token_type_field_data',
  label_count: [
    'singular' => '@count API token type item',
    'plural' => '@count API token type items',
  ],
  list_cache_tags: [
    'api_token_entity_api_token_type',
  ],
)]
class ApiTokenType extends ContentEntityBase implements ApiTokenTypeInterface {

  /**
   * {@inheritDoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['name'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Name'))
      ->setDescription(t('The API token type identifier.'))
      ->setRequired(TRUE)
      ->setSettings([
        'max_length' => 255,
        'text_processing' => 0,
      ])
      ->setDisplayOptions('view', [
        'type' => 'string',
        'weight' => 1,
      ])
      ->setDisplayOptions('form', [
        'type' => 'machine_name',
        'weight' => 1,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayConfigurable('view', TRUE)
      ->addConstraint('UniqueField')
      ->addConstraint('MachineName');

    return $fields;
  }

}
