<?php

namespace Drupal\api_token_entity\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks that the name contains only lowercase, numbers, underscore and dots.
 */
#[Constraint(
  id: 'MachineName',
  label: new TranslatableMarkup('Machine name', [], ['context' => 'Validation']),
  type: 'string'
)]
class MachineNameConstraint extends SymfonyConstraint {

  /**
   * The message that will be shown if the value is not valid.
   *
   * @var string
   */
  public $message = 'The name "@name" is not valid. Only lowercase letters, numbers, underscores, and dots are allowed.';

}
