<?php

namespace Drupal\Tests\api_token_entity\Functional;

use Drupal\api_token_entity\ApiTokenManager;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;
use Symfony\Component\HttpFoundation\Request;

/**
 * Tests the API token type access check.
 *
 * @group api_token_entity
 */
#[RunTestsInSeparateProcesses]
class ApiTokenTypeAccessCheckEntityTest extends ApiTokenEntityTestBase {

  /**
   * Tests access with valid recipes token.
   */
  public function testRecipesToken(): void {
    // Test unauthorized access - no authorization header.
    $request = Request::create('/test/api/recipes', 'GET');
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test unauthorized access - random authorization header.
    $request = Request::create('/test/api/recipes', 'GET');
    $request->headers->set('Authorization', 'ApiKey ' . ApiTokenManager::generateSecureApiTokenValue());
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test unauthorized access - wrong authorization header.
    $request = Request::create('/test/api/recipes', 'GET');
    $request->headers->set('Authorization', 'ApiKey ' . $this->apiKeys['restaurants']['bob']);
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test unauthorized access - wrong authorization header.
    $request = Request::create('/test/api/recipes', 'GET');
    $request->headers->set('Authorization', 'Bearer ' . $this->apiKeys['recipes']['alice']);
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test authorized access.
    $request = Request::create('/test/api/recipes', 'GET');
    $request->headers->set('Authorization', 'ApiKey ' . $this->apiKeys['recipes']['alice']);
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(200, $response->getStatusCode());
  }

  /**
   * Tests access with valid restaurants token.
   */
  public function testRestaurantsToken(): void {
    // Test unauthorized access - no authorization header.
    $request = Request::create('/test/api/restaurants', 'GET');
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test unauthorized access - random authorization header.
    $request = Request::create('/test/api/restaurants', 'GET');
    $request->headers->set('Authorization', 'ApiKey ' . ApiTokenManager::generateSecureApiTokenValue());
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test unauthorized access - wrong authorization header.
    $request = Request::create('/test/api/restaurants', 'GET');
    $request->headers->set('Authorization', 'ApiKey ' . $this->apiKeys['recipes']['alice']);
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test unauthorized access - wrong authorization header.
    $request = Request::create('/test/api/restaurants', 'GET');
    $request->headers->set('Authorization', 'Bearer ' . $this->apiKeys['restaurants']['bob']);
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(403, $response->getStatusCode());

    // Test authorized access.
    $request = Request::create('/test/api/restaurants', 'GET');
    $request->headers->set('Authorization', 'ApiKey ' . $this->apiKeys['restaurants']['bob']);
    $response = $this->httpKernel->handle($request);
    $this->assertEquals(200, $response->getStatusCode());
  }

}
