<?php

namespace Drupal\api_token_entity;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for 'api_token_entity' module entities.
 */
class ApiTokenEntityAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account): AccessResultInterface {
    return $account->hasPermission('administer api_token_entity entities') ? AccessResult::allowed() : AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line because Drupal's core inherited PHPDoc has array parameters with no value type specified.
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL): AccessResultInterface {
    return $account->hasPermission('administer api_token_entity entities') ? AccessResult::allowed() : AccessResult::neutral();
  }

}
