<?php

namespace Drupal\api_token_entity;

use Drupal\Core\Entity\EntityTypeManagerInterface;

/**
 * Service class to manage API token entities.
 */
class ApiTokenManager {

  /**
   * Constructs a new ApiTokenManager object.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {}

  /**
   * Returns if the token is valid.
   */
  public function checkApiToken(
    string $token_value,
    ?string $token_type = NULL,
    ?string $token_id = NULL,
  ): string|FALSE {
    $api_token_type = NULL;
    if (!is_null($token_type)) {
      $api_token_type_ids = $this->entityTypeManager
        ->getStorage('api_token_entity_api_token_type')
        ->loadByProperties(['name' => $token_type]);
      if (empty($api_token_type_ids)) {
        return FALSE;
      }
      $api_token_type = array_pop($api_token_type_ids);
    }

    // Get API token.
    $properties = array_filter([
      'type' => $api_token_type?->id(),
      'value' => md5($token_value),
      'name' => $token_id,
    ], fn ($value) => $value !== NULL);
    $api_token_ids = $this->entityTypeManager
      ->getStorage('api_token_entity_api_token')
      ->loadByProperties($properties);

    if (!empty($api_token_ids)) {
      /** @var \Drupal\api_token_entity\Entity\ApiToken $apiToken */
      $apiToken = array_pop($api_token_ids);
      return $apiToken->get('name')->getString();
    }

    return FALSE;
  }

  /**
   * Generate a secure API token value.
   */
  public static function generateSecureApiTokenValue(): string {
    return base64_encode(random_bytes(40));
  }

}
