<?php

namespace Drupal\api_token_entity;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Url;

/**
 * Defines a class to build a list of API token type entities.
 */
class ApiTokenTypeListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line because Drupal's core inherited PHPDoc has array parameters with no value type specified.
   */
  public function buildHeader(): array {
    $header = [];
    $header['name'] = [
      'data' => $this->t('Name'),
      'field' => 'name',
      'specifier' => 'name',
    ];
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line because Drupal's core inherited PHPDoc has array parameters with no value type specified.
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\api_token_entity\Entity\ApiTokenType $entity */
    $row = [];
    $row['name'] = $entity->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line because Drupal's core inherited PHPDoc has array parameters with no value type specified.
   */
  protected function getEntityIds() {
    $header = $this->buildHeader();
    // @phpstan-ignore-next-line false positive.
    return $this->getStorage()->getQuery()
      ->accessCheck(FALSE)
      ->tableSort($header)
      ->execute();
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line because Drupal's core inherited PHPDoc has array parameters with no value type specified.
   */
  public function render(): array {
    $build = parent::render();

    // Add a create button above the table.
    $build['create_button'] = [
      '#type' => 'link',
      '#title' => $this->t('Create a new @entityLabel', ['@entityLabel' => $this->entityType->getLabel()]),
      '#url' => Url::fromRoute('entity.api_token_entity_api_token_type.add_form'),
      '#attributes' => [
        'class' => ['button', 'button--action', 'button--primary'],
      ],
      '#weight' => -10,
    ];

    return $build;
  }

}
