<?php

namespace Drupal\api_token_entity\Plugin\Validation\Constraint;

use Drupal\Core\Field\FieldItemList;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the MachineName constraint.
 */
class MachineNameConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $value, Constraint $constraint): void {
    assert($constraint instanceof MachineNameConstraint);

    if (is_null($value)) {
      return;
    }

    $name = $value instanceof FieldItemList ? $value->value : $value;

    // Check if the name contains only allowed characters.
    if (!preg_match('/^[a-z0-9_.]+$/', $name)) {
      $this->context->addViolation($constraint->message, [
        '@name' => $name,
      ]);
    }
  }

}
