<?php

namespace Drupal\api_token_entity_test\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Test controller for API token testing.
 */
class TestController extends ControllerBase {

  /**
   * Test endpoint: recipes.
   */
  public function recipes(): JsonResponse {
    return new JsonResponse(
      [
        [
          "name" => "Recipe 1",
          "time" => "60",
          "difficulty" => "6",
          "ingredients" => ["Ingredient 1", "Ingredient 2"],
        ],
        [
          "name" => "Recipe 2",
          "time" => "45",
          "difficulty" => "3",
          "ingredients" => ["Ingredient 1", "Ingredient 3"],
        ],
      ]
    );
  }

  /**
   * Test endpoint: restaurants.
   */
  public function restaurants(): JsonResponse {
    return new JsonResponse(
      [
        [
          "name" => "Restaurant 1",
          "street" => "Street 1",
          "city" => "City 1",
        ],
        [
          "name" => "Restaurant 2",
          "street" => "Street 2",
          "city" => "City 2",
        ],
      ]
    );
  }

}
