<?php

/**
 * Copyright 2020 Google Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

namespace Drupal\apigee_edge_teams\Entity;

use Drupal\Core\Entity\Controller\EntityController;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Title provider for team_invitation.
 */
class TeamInvitationTitleProvider extends EntityController implements TeamInvitationTitleProviderInterface {

  /**
   * {@inheritdoc}
   */
  public function acceptTitle(RouteMatchInterface $route_match, ?EntityInterface $_entity = NULL) {
    if ($entity = $this->doGetEntity($route_match, $_entity)) {
      return $this->t('Accept %label', ['%label' => $entity->label()]);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function declineTitle(RouteMatchInterface $route_match, ?EntityInterface $_entity = NULL) {
    if ($entity = $this->doGetEntity($route_match, $_entity)) {
      return $this->t('Decline %label', ['%label' => $entity->label()]);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function resendTitle(RouteMatchInterface $route_match, ?EntityInterface $_entity = NULL) {
    if ($entity = $this->doGetEntity($route_match, $_entity)) {
      return $this->t('Resend %label', ['%label' => $entity->label()]);
    }
  }

}
