# APNs PHP (Push Notifications for Apple Devices)

This module integrates [edamov/pushok](https://github.com/edamov/pushok) as a Drupal service.

This module is a community implementation and not affiliated with the edamov/pushok project.

This is a developer module and you will need to write code for it to be useful.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/firebase_php).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/firebase_php).


## Warning

This is an API module, but the module is not finalized. It could change at any time.


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration > Extend.
1. At `/admin/config/system/apns`, set the credentials path.

### How to Get the Configuration Credentials

You will need an Apple Developer account.

View the Apple documentation here: https://developer.apple.com/help/account/keys/get-a-key-identifier/

* Go to Key.
* Create a new key for sandbox and another for production (or a single key for both).
* Give the key a name and select APNs.
* Configure the key using the button (set the environment).
* If you want to restrict the key to just a single app, set the "Key restriction" to "Topic Specific" and the topic to the app bundle ID.
* Register the key.

**Do NOT commit the key to your repository.**

You need to know the Key ID.

If your private files directory is inside your webroot, move it outside your webroot. (If your host doesn't let you do this, get a new host.)


## FAQ (optional)

**Q: How can I send a test message?**

**A:** Go to `admin/config/system/apns/test`.


## Maintainers

- Patrick Kenny - [ptmkenny](https://www.drupal.org/u/ptmkenny)
