<?php

declare(strict_types=1);

namespace Drupal\apns_php;

/**
 * Provides an interface for working with push notifications.
 *
 * THIS MODULE IS IN DEVELOPMENT AND THIS API WILL CHANGE!
 */
interface ApnsPhpMessagingApiInterface {

  /**
   * Sends a message to a single device.
   *
   * @param string $device_token
   *   The token of the device to send a message to.
   * @param string|null $notification_title
   *   The title of the notification.
   * @param string|null $notification_body
   *   The body of the notification.
   * @param string|null $notification_url
   *   The optional notification URL.
   * @param int|null $badge_count
   *   The optional badge count for the device.
   * @param bool|null $silent
   *   Set to TRUE for a silent notification (no sound under any circumstances).
   *   Otherwise, a sound will be played if device sounds are on.
   *
   * @return array
   *   The array from firebase-php messaging->send().
   */
  public function sendMessageSingleDevice(
    string $device_token,
    ?string $notification_title,
    ?string $notification_body,
    ?string $notification_url = NULL,
    ?int $badge_count = NULL,
    ?bool $silent = NULL,
  ): array;

  /**
   * Sends a single message to multiple devices.
   *
   * @param array $device_tokens
   *   An array of all the device tokens to send the message to.
   * @param string|null $notification_title
   *   The title of the notification.
   * @param string|null $notification_body
   *   The body of the notification.
   * @param string|null $notification_url
   *   The optional notification URL.
   * @param int|null $badge_count
   *   The optional badge count for the device.
   * @param bool|null $silent
   *   Set to TRUE for a silent notification (no sound under any circumstances).
   *    Otherwise, a sound will be played if device sounds are on.
   *
   * @return array
   *   A report of message showing whether message sending succeeded or failed.
   */
  public function sendMessageMultipleDevices(
    array $device_tokens,
    ?string $notification_title,
    ?string $notification_body,
    ?string $notification_url = NULL,
    ?int $badge_count = NULL,
    ?bool $silent = NULL,
  ): array;

  /**
   * Validates a registration token with Google's servers.
   *
   * @param string $token
   *   The registration token to validate.
   *
   * @return bool
   *   TRUE if the token is valid. FALSE if not.
   */
  public function validateToken(string $token): bool;

}
