<?php

declare(strict_types=1);

namespace Drupal\apns_php\Enum;

/**
 * Settings values for APNs PHP.
 */
enum ApnsPhpSettings: string {
  case AppleDeveloperTeamId = 'team_id';
  case AppBundleId = 'app_bundle_id';
  case CertificateKeyId = 'key_id';
  case CertificatePath = 'certificate_path';
  case CertificateSecret = 'certificate_secret';
  case UseProduction = 'is_production';
  case LoggingLevel = 'logging_level';
  case LogTokenValidationResult = 'log_token_validation_result';
}
