<?php

namespace Drupal\aspect_ratio\Form;

use Drupal\Core\Batch\BatchBuilder;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class BatchCalculateAspectRatio extends FormBase {
  public function getFormId() {
    return 'aspect_ratio.batch_calculate';
  }

  private static function getAllMediaIds() {
    $media_ids = \Drupal::entityQuery('media')
      ->condition('bundle', 'image') // TODO find all bundles that have field_aspect_ratio enabled
      ->accessCheck(FALSE)
      ->execute();
    return $media_ids;
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $media_ids = self::getAllMediaIds();
    $build = [
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'p',
        '#value' => $this->t('There are @count media items that will be calculated.', ['@count' => count($media_ids)]),
      ],
      'actions' => [
        '#type' => 'actions',
        'submit' => [
          '#type' => 'submit',
          '#value' => 'Calculate all aspect ratios',
        ]
      ]
    ];
    return $build;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $batch = new BatchBuilder();
    $media_item_ids = static::getAllMediaIds();
    foreach ($media_item_ids as $id) {
      $batch->addOperation('aspect_ratio_calculate_and_save_by_id', [$id]);
    }
    batch_set($batch->toArray());
  }
}