<?php

namespace Drupal\assets_for_text\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Provides the Library Key pair entity.
 *
 * @ConfigEntityType(
 *   id = "assets_for_text_key",
 *   label = @Translation("Library Key pair"),
 *   label_collection = @Translation("Library Key pairs"),
 *   label_singular = @Translation("library key pair"),
 *   label_plural = @Translation("library key pairs"),
 *   label_count = @PluralTranslation(
 *     singular = "@count library key pair",
 *     plural = "@count library key pairs",
 *   ),
 *   handlers = {
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *     "form" = {
 *       "default" = "Drupal\assets_for_text\Form\AssetsForTextKeyForm",
 *       "add" = "Drupal\assets_for_text\Form\AssetsForTextKeyForm",
 *       "edit" = "Drupal\assets_for_text\Form\AssetsForTextKeyForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "list_builder" = "Drupal\assets_for_text\Entity\Handler\AssetsForTextKeyListBuilder",
 *   },
 *   admin_permission = "administer assets_for_text_key entities",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "key",
 *     "library",
 *   },
 *   links = {
 *     "add-form" = "/admin/config/content/assets_for_text_key/add",
 *     "canonical" = "/admin/config/content/assets_for_text_key/{assets_for_text_key}",
 *     "collection" = "/admin/config/content/assets_for_text_key",
 *     "edit-form" = "/admin/config/content/assets_for_text_key/{assets_for_text_key}/edit",
 *     "delete-form" = "/admin/config/content/assets_for_text_key/{assets_for_text_key}/delete",
 *   },
 * )
 */
class AssetsForTextKey extends ConfigEntityBase implements AssetsForTextKeyInterface {

  /**
   * Machine name.
   *
   * @var string
   */
  protected $id = '';

  /**
   * Name.
   *
   * @var string
   */
  protected $label = '';

  /**
   * Key.
   *
   * @var string
   */
  protected $key = '';

  /**
   * Library.
   *
   * @var string
   */
  protected $library = '';

}
