<?php

namespace Drupal\assets_for_text\Form;

use Drupal\Core\Asset\LibraryDiscoveryInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * TODO: class docs.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * The library discovery service.
   *
   * @var \Drupal\Core\Asset\LibraryDiscoveryInterface
   */
  protected $libraryDiscovery;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('library.discovery'),
    );
  }

  /**
   * Creates a SettingsForm instance.
   *
   * @param \Drupal\Core\Asset\LibraryDiscoveryInterface $library_discovery
   *   The library discovery service.
   */
  public function __construct(
    LibraryDiscoveryInterface $library_discovery,
  ) {
    $this->libraryDiscovery = $library_discovery;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'assets_for_text_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);

//    $this->libraryDiscovery->getLibraryByName();
    $libs = \Drupal::service('libraries_ui')->getAllLibraries();
    $lib_names = [];
    foreach ($libs as $ext => $ext_libs) {
      foreach ($ext_libs as $lib_name => $lib) {
        unset($lib);
        $lib_names[] = $ext . '/' . $lib_name;
      }
    }

    $config = $this->config('assets_for_text.settings');

    $form['element'] = [
      '#type' => 'textfield',
      '#title' => t('Enter a value'),
      '#description' => t('Enter a description'),
      '#required' => TRUE,
      '#default_value' => $config->get('element'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $config = $this->config('assets_for_text.settings');

    if ($form_state->hasValue('element')) {
      $config->set('element', $form_state->getValue('element'));
    }

    $config->save();
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['assets_for_text.settings'];
  }

}
