<?php

namespace Drupal\assets_for_text\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides the default form handler for the Library Key pair entity.
 */
class AssetsForTextKeyForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $form['label'] = [
      '#type' => "textfield",
      '#title' => $this->t("Name"),
      '#description' => $this->t("The human-readable name of this entity"),
      '#default_value' => $this->entity->get('label'),
      '#required' => "TRUE",
    ];
    $form['id'] = [
      '#type' => "machine_name",
      '#title' => $this->t("Name"),
      '#description' => $this->t("A unique machine-readable name for this entity. It must only contain lowercase letters, numbers, and underscores."),
      '#default_value' => $this->entity->id(),
      '#required' => "TRUE",
      '#machine_name' => [
        'exists' => ['Drupal\assets_for_text\Entity\AssetsForTextKey', 'load'],
        'source' => ['label'],
      ],
    ];
    $form['key'] = [
      '#type' => "textfield",
      '#title' => $this->t("Key"),
      '#description' => $this->t("Provide a CSS class (as .example) or an ID (as #example) to trigger the adding of the library."),
      '#default_value' => $this->entity->get('key'),
    ];
    $lib_names = \Drupal::service('')->getAllLibraries();
    $form['library'] = [
      '#type' => "select",
      '#options' => $lib_names,
      '#title' => $this->t("Library"),
      '#description' => $this->t("Select the library to load when the provided key is present in text."),
      '#default_value' => $this->entity->get('library'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $saved = parent::save($form, $form_state);
    $form_state->setRedirectUrl($this->entity->toUrl('collection'));

    return $saved;
  }

}
