<?php

namespace Drupal\assets_for_text;

use Drupal\Core\Entity\EntityTypeManagerInterface;

/**
 * Methods to get available libraries and load our keyword-library pairings.
 */
class KeyLibraryConfig {

  /**
   * Creates a KeyLibraryConfig instance.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entity_type_manager,
  ) {
    // No need to set properties courtesy PHP 8 constructor property promotion.
  }

  public function loadAssetForTextKeyConfigEntities(): array {
    // \Drupal::service('entity_type.manager')->getStorage('assets_for_text_key');
    /** @var Drupal\Core\Config\Entity\ConfigEntityStorage $config */
    $config = $this->entity_type_manager->getStorage('assets_for_text_key');
    return $config->loadMultiple();
  }

  public function listKeyLibraryPairs(): array {
    // We key this by config ID not 'key' because keys might get re-used.
    $keys_libraries = [];
    $config_entities = $this->loadAssetForTextKeyConfigEntities();
    foreach ($config_entities as $cent) {
      $keys_libraries[$cent->id()] = [
        'key' => $cent->get('key'),
        'library' => $cent->get('library'),
      ];
    }
    return $keys_libraries;
  }
}
