<?php

namespace Drupal\assist_for_wcag\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AssistForWcagSettingsForm extends ConfigFormBase
{

  const CONFIG_NAME = 'assist_for_wcag.settings';

  public function getFormId()
  {
    return 'assist_for_wcag_settings_form';
  }

  protected function getEditableConfigNames()
  {
    return [static::CONFIG_NAME];
  }

  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $config = $this->config(static::CONFIG_NAME);
    $token = $config->get('token');

    $form['#attributes']['class'][] = 'assist-for-wcag-admin';

    $form['token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Token'),
      '#default_value' => $token,
      '#description' => $this->t('Enter your accessibility widget token. If you do not have one, <a href="https://wcag.dock.codes/my-account/tokens" target="_blank">get it here</a>.'),
      '#attributes' => ['class' => ['token-field']],
    ];

    if (!empty($token)) {
      $form['widget_link'] = [
        '#type' => 'markup',
        '#markup' => '<p>' . str_replace('_token_', $token, $this->t('Go to the <a href="https://wcag.dock.codes/my-account/token-widget/_token_/" target="_blank">widget configuration</a>.')) . '</p>',
      ];
    }

    $this->attachLibraries($form);

    return parent::buildForm($form, $form_state);
  }

  protected function attachLibraries(array &$form)
  {
    $form['#attached']['library'][] = 'assist_for_wcag/admin';
  }

  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    $this->configFactory->getEditable(static::CONFIG_NAME)
      ->set('token', trim($form_state->getValue('token')))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
