<?php

namespace Drupal\association_menu\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\association\Entity\AssociatedEntityInterface;
use Drupal\association\Entity\AssociationInterface;

/**
 * Event class for when new associated entity menu links are being created.
 *
 * Event is dispatched when a new menu item is being created for a new
 * associated entity.
 */
class MenuLinkCreateEvent extends Event {

  /**
   * Creates a new instance of the MenuLinksAlterEvent class.
   *
   * @param array $menuItemData
   *   The menu items to be altered by listeners of this event.
   * @param \Drupal\association\Entity\AssociationInterface $association
   *   The entity association the menu belongs to.
   * @param \Drupal\association\Entity\AssociatedEntityInterface $entity
   *   The associated entity that the menu link is being created on behalf of.
   */
  public function __construct(
    protected array &$menuItemData,
    protected AssociationInterface $association,
    protected AssociatedEntityInterface $entity,
  ) {}

  /**
   * Gets the entity association these menu item belong to.
   *
   * @return \Drupal\association\Entity\AssociationInterface
   *   The entity association the menu is being build for.
   */
  public function getAssociation(): AssociationInterface {
    return $this->association;
  }

  /**
   * The associated entity that this menu item is being created for.
   *
   * @return \Drupal\association\Entity\AssociatedEntityInterface
   *   The associated entity item the menu item is being created for.
   */
  public function getEntity(): AssociatedEntityInterface {
    return $this->entity;
  }

  /**
   * A reference to the values array of the new menu item being created.
   *
   * @return array
   *   Menu item values that will be stored for the newly created menu item.
   */
  public function &getValues(): array {
    return $this->menuItemData;
  }

}
