<?php

namespace Drupal\asyntai\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * API Controller for Asyntai AJAX endpoints.
 */
class ApiController extends ControllerBase {

  /**
   * Save connection settings.
   */
  public function save(Request $request) {
    $content = $request->getContent();
    $data = json_decode($content, TRUE);

    if (!is_array($data)) {
      return new JsonResponse(['success' => FALSE, 'error' => 'Invalid JSON'], 400);
    }

    $site_id = isset($data['site_id']) ? trim((string) $data['site_id']) : '';

    if ($site_id === '') {
      return new JsonResponse(['success' => FALSE, 'error' => 'missing site_id'], 400);
    }

    $config = $this->config('asyntai.settings');
    $config_factory = \Drupal::configFactory()->getEditable('asyntai.settings');

    $config_factory->set('site_id', $site_id);

    if (!empty($data['script_url'])) {
      $config_factory->set('script_url', trim((string) $data['script_url']));
    }
    else {
      $config_factory->set('script_url', 'https://asyntai.com/static/js/chat-widget.js');
    }

    if (!empty($data['account_email'])) {
      $config_factory->set('account_email', trim((string) $data['account_email']));
    }

    $config_factory->save();

    $saved = $this->config('asyntai.settings');

    return new JsonResponse([
      'success' => TRUE,
      'saved' => [
        'site_id' => $saved->get('site_id'),
        'script_url' => $saved->get('script_url'),
        'account_email' => $saved->get('account_email'),
      ],
    ]);
  }

  /**
   * Reset connection settings.
   */
  public function reset(Request $request) {
    $config_factory = \Drupal::configFactory()->getEditable('asyntai.settings');
    $config_factory->set('site_id', '');
    $config_factory->set('script_url', 'https://asyntai.com/static/js/chat-widget.js');
    $config_factory->set('account_email', '');
    $config_factory->save();

    return new JsonResponse(['success' => TRUE]);
  }

}
