<?php

declare(strict_types=1);

namespace Drupal\atd\Hook;

use Drupal\Core\Extension\Extension;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Manipulates profile, module and theme's meta information.
 */
class AtdTranslationInfo {

  /**
   * The directory that contains the translation files.
   */
  private const string TRANSLATION_DIRECTORY = 'translations';

  /**
   * Pattern to locate the .po file containing the translations.
   */
  private const string INTERFACE_TRANSLATION_SERVER_PATTERN = '%project.%language.po';

  /**
   * Implements hook_system_info_alter().
   */
  #[Hook('system_info_alter')]
  public function systemInfoAlter(array &$info, Extension $file, string $type): void {
    // For all extensions that have a 'translations/' directory, add the
    // appropriate translation properties (so that the .po file containing the
    // translations is found).
    if (is_dir($file->getPath() . DIRECTORY_SEPARATOR . self::TRANSLATION_DIRECTORY)) {
      $info['interface translation project'] = $file->getName();
      $info['interface translation server pattern'] = $file->getPath() . DIRECTORY_SEPARATOR . self::TRANSLATION_DIRECTORY . DIRECTORY_SEPARATOR . self::INTERFACE_TRANSLATION_SERVER_PATTERN;
    }
  }

}
