<?php

namespace Drupal\audio_embed_field\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure audio_embed_field settings for this site.
 */
class AudioEmbedFieldAdminSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'audio_embed_field_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['audio_embed_field.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('audio_embed_field.settings');

    $form['soundcloud'] = [
      '#type' => 'details',
      '#title' => $this->t('Soundcloud settings'),
      '#open' => TRUE,
    ];

    $form['soundcloud']['soundcloud_id'] = [
      '#default_value' => $config->get('soundcloud_id'),
      '#description' => $this->t('Your SoundCloud application Client ID. Required for OAuth 2.1 authentication. Find your apps at <a target="_blank" href="https://soundcloud.com/you/apps">https://soundcloud.com/you/apps</a>'),
      '#maxlength' => 255,
      '#size' => 60,
      '#title' => $this->t('SoundCloud Client ID'),
      '#type' => 'textfield',
    ];

    $form['soundcloud']['soundcloud_secret'] = [
      '#default_value' => $config->get('soundcloud_secret'),
      '#description' => $this->t('Your SoundCloud application Client Secret. Required for OAuth 2.1 authentication.'),
      '#maxlength' => 255,
      '#size' => 60,
      '#title' => $this->t('SoundCloud Client Secret'),
      '#type' => 'textfield',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->config('audio_embed_field.settings');
    $config
      ->set('soundcloud_id', $form_state->getValue('soundcloud_id'))
      ->set('soundcloud_secret', $form_state->getValue('soundcloud_secret'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
