# Audit

A Drupal site auditing framework that helps identify configuration issues,
performance problems, and best practice violations.

## What It Does

Audit scans your Drupal site and generates scores for different areas like
performance, SEO, security updates, and content structure. Each audit produces
a score from 0-100, and all scores combine into an overall Project Score.

Analysis runs in real-time when you view audit pages. Only scores are stored
persistently (in Drupal's State API) for dashboard display.

## Requirements

- Drupal 10.3+ or 11.x
- PHP 8.1+

## Installation

```bash
drush en audit
```

Enable all audits at once:

```bash
drush en audit_all
```

## Configuration

Go to **Administration > Reports > Audit > Settings** to configure:

- **Primary user type**: Whether your site serves anonymous visitors,
  registered users, or both. This affects performance recommendations.
- **Score multipliers**: Adjust how much each audit affects the Project Score.
  Set critical audits higher (5) and less important ones lower (1-2).

## Usage

Go to **Administration > Reports > Audit** to see all audit results.

- **Project Score**: Overall site health (weighted average of all audits)
- **Run all audits**: Execute all enabled audits and update scores
- Click any audit to see detailed results and recommendations

Each audit detail page shows:
- Sections with issues (faceted list with filters)
- Informational sections (tables)
- Score breakdown by factor

## Available Audits

| Audit | Purpose |
|-------|---------|
| Status | Server compatibility (PHP, database versions) |
| Modules | Module recommendations and unused extensions |
| Fields | Content structure complexity |
| Twig | Template code quality |
| Views | Views performance and caching |
| i18n | Multilingual configuration |
| SEO | Search engine optimization |
| Performance | Caching and aggregation settings |
| Database | Database size and structure |
| Images | Responsive image configuration |
| Updates | Security and module updates |
| Blocks | Block configuration and cache settings |

## Permissions

- **View audit results**: See audit reports
- **Administer audit configuration**: Change settings

## Creating Custom Audits

Create a submodule with an `AuditAnalyzer` plugin. See `CLAUDE.md` for
technical documentation.

## Architecture

- **Real-time analysis**: Results are generated fresh on each page view
- **Score persistence**: Only scores stored in State API (no file storage)
- **Plugin-based**: Each audit is a separate submodule with its own analyzer
- **Component UI**: Consistent rendering via AuditComponentBuilder service
