# Audit Performance

Analyzes caching and performance configuration.

## Why This Matters

Proper caching is the single most important factor for a fast Drupal site.
Missing or misconfigured cache settings can make pages 10-100x slower.

## What It Checks

- **CSS/JS aggregation**: Are assets combined and minified?
- **Page caching**: Is anonymous page caching enabled?
- **Cache modules**: Are the right cache modules enabled for your site type?
- **Development settings**: Is Twig debug or other dev settings left on?

## Configuration

Uses the "Primary user type" setting to recommend appropriate cache modules:

- **Anonymous**: Sites mostly visited by non-logged-in users
- **Registered**: Sites where most visitors are logged in
- **Mixed**: Sites with significant traffic from both
