# Audit Twig

Analyzes Twig templates for code quality and performance issues.

## Why This Matters

Poor template code can break Drupal's caching system, causing slow page loads.
Common mistakes include putting logic in templates that belongs in PHP, or
accessing services directly instead of using preprocess functions.

## What It Checks

- **Anti-patterns**: Logic that shouldn't be in templates
- **Cache issues**: Code that prevents proper page caching
- **Direct service calls**: Using `drupal_get_path()` or similar in templates

## Configuration

Uses the "Directories to scan" setting from main Audit configuration to know
which theme folders to analyze.
