<?php

declare(strict_types=1);

namespace Drupal\audit\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an AuditAnalyzer plugin attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class AuditAnalyzer extends Plugin {

  /**
   * Constructs an AuditAnalyzer attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable label.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $menu_title
   *   The short title for menu tabs (without "Audit" prefix).
   * @param string|null $output_directory
   *   The output directory for JSON files.
   * @param int $weight
   *   The default weight/multiplier for project score calculation (0-5).
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly ?TranslatableMarkup $menu_title = NULL,
    public readonly ?string $output_directory = NULL,
    public readonly int $weight = 3,
  ) {}

}
