<?php

declare(strict_types=1);

namespace Drupal\audit;

use Drupal\audit\Attribute\AuditAnalyzer;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Plugin manager for AuditAnalyzer plugins.
 */
class AuditAnalyzerPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new AuditAnalyzerPluginManager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache backend.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cache_backend,
    ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct(
      'Plugin/AuditAnalyzer',
      $namespaces,
      $module_handler,
      AuditAnalyzerInterface::class,
      AuditAnalyzer::class,
    );
    $this->alterInfo('audit_analyzer_info');
    $this->setCacheBackend($cache_backend, 'audit_analyzer_plugins');
  }

}
