<?php

declare(strict_types=1);

namespace Drupal\audit\Plugin\QueueWorker;

use Drupal\audit\Service\AuditRunner;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\Attribute\QueueWorker;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Processes audit analyzer tasks.
 *
 * @QueueWorker(
 *   id = "audit_processor",
 *   title = @Translation("Audit Processor"),
 *   cron = {"time" = 60}
 * )
 */
class AuditProcessor extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs an AuditProcessor.
   *
   * @param array $configuration
   *   The plugin configuration.
   * @param string $plugin_id
   *   The plugin ID.
   * @param mixed $plugin_definition
   *   The plugin definition.
   * @param \Drupal\audit\Service\AuditRunner $auditRunner
   *   The audit runner service.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected readonly AuditRunner $auditRunner,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(
    ContainerInterface $container,
    array $configuration,
    $plugin_id,
    $plugin_definition,
  ): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('audit.runner'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data): void {
    $analyzer_id = $data['analyzer_id'] ?? NULL;

    if ($analyzer_id === NULL) {
      return;
    }

    $this->auditRunner->runAnalyzer($analyzer_id);
  }

}
