# Audit Export

Audit Export is a powerful auditing module for Drupal 11, designed to help site
administrators and developers analyze and report on the entity structure and
overall usage of their Drupal site. It allows for detailed audits, reports,
and exporting capabilities, making it easier to monitor and maintain site
health over time.

## Features

- **Run Audits on Entity Structure and Site Usage**: Audit Export provides
a comprehensive set of audits to determine the structure of content entities,
user roles, blocks, menus, taxonomy, views, and more. Easily keep track of
what's happening on your site and how various entities are being used.

- **Automated Reports via Cron**: Set up reports to run automatically through
Drupal's cron system. Ensure your audit data is always up to date and
accessible when you need it.

- **Export Reports in CSV Format**: Download and export reports in CSV format
to use in external reporting tools or for further analysis in custom workflows.
Export functionality allows for seamless integration with custom data
pipelines.

- **Drush Integration**: Run audits and generate reports directly from the
command line using Drush. This allows for easy automation and integration
into CI/CD workflows.

- **Custom Plugin Architecture**: Build and integrate your own custom audit
reports by extending the Audit Export plugin system. Whether you need to audit
custom data or build reports tailored to your unique use cases, the plugin
architecture makes it easy to extend the module's functionality.

- **Remote Posting for Advanced Use Cases**: Optionally configure the module
to remotely post audit data to external endpoints for more advanced use cases.
This can be useful for integrating with external monitoring systems or
third-party applications that need to consume audit data.

- **Tool API & MCP Integration**: Expose audit functionality to AI agents and
external systems through the Tool API module. This enables LLMs and MCP clients
to query audit data, run audits, and export reports programmatically.

## Use Cases

- **Entity Structure Audits**: Understand how content types, user roles,
taxonomy vocabularies, and other entities are used across your site.
Identify unused or poorly configured entities and optimize your site's
structure.

- **Automated Reporting**: Schedule automated reports to run via cron,
ensuring that you always have the latest audit data available for review.
Stay informed about changes and trends in site usage.

- **Custom Reports**: Export audit data in CSV format to easily integrate with
third-party tools, such as Google Sheets, Excel, or custom-built analytics
platforms.

- **Custom Plugin Development**: Build your own audits by leveraging the Audit
Export plugin system. Whether auditing custom entities, third-party modules,
or specific configurations, Audit Export gives you the flexibility to create
the reports that matter most to your organization.

- **Advanced Monitoring**: Use the remote posting feature to send audit data to
external systems for further processing, monitoring, or analysis. Keep track of
site health across multiple environments by pushing reports to central
monitoring systems.

- **AI-Powered Analysis**: Enable AI agents to analyze your site's structure
and health by exposing audit data through the Tool API. Use with MCP-compatible
clients to allow LLMs to query and reason about your Drupal site.

## Submodules

Audit Export includes several submodules for extended functionality:

### Audit Export Core

The foundational module providing the plugin system, base classes, and
essential services. This is a required dependency.

### Audit Export Post

Enables automatic posting of audit data to external endpoints when reports
are generated. Supports multiple authentication methods and configurable
connection options.

### Audit Export Tool

Integrates with the [Tool API](https://www.drupal.org/project/tool) module
to expose audit functionality to AI agents and external systems. Provides
the following tools:

| Tool | Description |
|------|-------------|
| **List Audits** | Lists all available audit plugins with group filtering |
| **Get Definition** | Retrieves schema and metadata for a specific audit |
| **Run Audit** | Executes an audit and generates report data |
| **Get Report** | Retrieves stored audit data with pagination |
| **Get Report Row** | Fetches a specific row by index or identifier |
| **Queue Audit** | Queues audits for background processing |
| **Export CSV** | Exports audit data to CSV format |
| **Clear Data** | Clears stored data for audits |
| **Derived Tools** | Auto-generated tools for each audit plugin |

When used with the [MCP module](https://www.drupal.org/project/mcp), these
tools become available to AI agents through the Model Context Protocol.

## Installation

1. Download and install the module in your Drupal 11 site. You can do this by
placing the module in the `/modules/custom` directory or installing it through
Composer.

    ```bash
    composer require drupal/audit_export
    ```

2. Enable the module:

    ```bash
    drush en audit_export
    ```

3. Configure the module by navigating to the admin interface at
`/admin/config/system/audit-export`.

## Usage

### Running Audits via Drush

You can run audits directly via Drush commands. This is useful for
automating reports in scripts or running ad-hoc audits from the command line.

```bash
drush audit-export:run
```

### Exporting Reports

Once audits have been run, you can export the results as CSV files from the
admin interface or directly via Drush commands.

```bash
drush audit-export:export --format=csv
```

### Setting up Cron
To automate report generation, set up cron jobs in your Drupal site to run
audits periodically. Visit the cron settings page to configure when these jobs
run.

### Creating Custom Audit Plugins
_Coming Soon_

### License
This project is licensed under the GNU General Public License, version 2.

### Maintainers
Will Jackson - Module Maintainer
Contributions are welcome! Please submit issues and pull requests through
the GitHub repository.
