# Audit Export Core

Audit Export Core provides the foundational functionality and API for the Audit Export module suite. This submodule contains the core plugin system, base classes, and essential services that enable audit reporting and export capabilities in Drupal 10 and 11.

## Overview

This module is a required dependency for Audit Export and should not be used standalone. It provides:

- Base plugin architecture for audit reports
- Core services and APIs for audit execution
- Export functionality and formatters
- Database schema and entity definitions
- Drush command infrastructure

## Installation

Audit Export Core is automatically installed as a dependency when you install the main Audit Export module.

### Manual Installation

If you need to enable it manually, navigate to `/admin/modules` in the Drupal admin interface and enable the Audit Export Core module.

**Note**: This module requires the parent Audit Export module to be present in your codebase.

## Usage

This module does not provide any user-facing functionality on its own. All features and usage instructions are available through the main Audit Export module.

For complete documentation, configuration options, and usage examples, please refer to the [Audit Export module documentation](../README.md).

## Requirements

- Drupal: ^10 || ^11
- Audit Export (parent module)

## Maintainers

[Will Jackson](https://www.drupal.org/u/wjackson)
For issues, feature requests, or contributions, please use the main Audit Export module's issue queue.
