# Audit Export Tool

Audit Export Tool integrates the Audit Export module with Drupal's
[Tool API](https://www.drupal.org/project/tool), enabling AI agents and
external systems to interact with audit functionality through a standardized
tool interface. This integration is particularly useful for MCP (Model Context
Protocol) clients, LLMs, and other automated systems that need to query or
manage site audit data.

## Features

- **Tool API Integration**: Exposes all audit functionality as Tool API plugins
- **MCP Compatible**: Works seamlessly with the MCP module for AI agent access
- **Derived Tools**: Automatically generates convenience tools for each
  registered audit plugin
- **Pagination Support**: Built-in pagination for handling large datasets
- **Flexible Output**: Returns structured data suitable for programmatic
  consumption

## Requirements

- Audit Export Core module
- [Tool API](https://www.drupal.org/project/tool) module

## Installation

1. Ensure the Tool API module is installed:

    ```bash
    composer require drupal/tool
    ```

2. Enable the module:

    ```bash
    drush en audit_export_tool
    ```

## Available Tools

### Core Tools

| Tool ID | Name | Description |
|---------|------|-------------|
| `audit_export_list` | List Audits | Lists all available audit plugins with optional group filtering |
| `audit_export_definition` | Get Audit Definition | Retrieves the schema and metadata for a specific audit |
| `audit_export_run` | Run Audit | Executes an audit and generates report data |
| `audit_export_report_get` | Get Audit Report | Retrieves stored audit report data with pagination |
| `audit_export_report_row` | Get Audit Report Row | Retrieves a specific row by index or identifier value |
| `audit_export_queue` | Queue Audit | Queues an audit for background processing via cron |
| `audit_export_csv` | Export Audit to CSV | Exports audit data to CSV format |
| `audit_export_clear` | Clear Audit Data | Clears stored data for one or all audits |

### Derived Tools

In addition to the core tools, this module automatically generates a derived
tool for each registered audit plugin. These provide a convenient way to
retrieve audit data without specifying the audit ID.

For example, if you have a `content_type_audit` plugin, a derived tool named
`audit_export_derived:content_type_audit` will be automatically created.

Derived tools accept the following parameters:
- `limit`: Maximum number of rows to return (default: 100)
- `page`: Page number for pagination (default: 1)

## Usage Examples

### List Available Audits

```json
{
  "tool": "audit_export_list",
  "parameters": {
    "group": "content",
    "include_last_run": true
  }
}
```

### Run an Audit

```json
{
  "tool": "audit_export_run",
  "parameters": {
    "audit_id": "content_type_audit",
    "clear_existing": true,
    "return_data": true
  }
}
```

### Get Audit Report with Pagination

```json
{
  "tool": "audit_export_report_get",
  "parameters": {
    "audit_id": "content_type_audit",
    "page": 1,
    "limit": 50,
    "include_headers": true
  }
}
```

### Find a Specific Row by Identifier

```json
{
  "tool": "audit_export_report_row",
  "parameters": {
    "audit_id": "content_type_audit",
    "identifier_value": "article"
  }
}
```

### Use a Derived Tool

```json
{
  "tool": "audit_export_derived:content_type_audit",
  "parameters": {
    "limit": 10,
    "page": 1
  }
}
```

### Export to CSV

```json
{
  "tool": "audit_export_csv",
  "parameters": {
    "audit_id": "content_type_audit",
    "save_to_file": true,
    "include_headers": true
  }
}
```

## MCP Integration

When used with the [MCP module](https://www.drupal.org/project/mcp), these
tools become available to AI agents through the Model Context Protocol. The
MCP module's Tool API plugin automatically exposes all audit tools to
connected clients.

Tool names in MCP are prefixed with the plugin namespace. For example:
- `audit-export-tool:tools_audit_export_list`
- `audit-export-tool:tools_audit_export_run`
- `audit-export-tool:tools_audit_export_derived___content_type_audit`

Note: Colons in tool IDs are converted to triple underscores (`___`) for
MCP compatibility.

## Permissions

The following permissions control access to audit tools:

- **View audit export reports**: Required to read audit data
- **Run audit export**: Required to execute audits
- **Export audit reports**: Required to generate CSV exports

## Maintainers

- [Will Jackson](https://www.drupal.org/u/wjackson)

For issues, feature requests, or contributions, please use the main
Audit Export module's issue queue.
