<?php

/**
 * Callback for processing an audit.
 *
 * @param string $audit_name
 *   The name of the audit to process.
 *
 * @return string
 *   The result of the audit processing.
 * @throws \Exception
 */
function audit_export_core_audit_process(string $audit_name): string {
  global $user;
  $audit = AuditExportAudit::getAudits()[$audit_name];

  if (class_exists($audit->className)) {
    $auditDataInstance = new $audit->className();
    $audit_report = new AuditExportAuditReport($audit, $auditDataInstance, $user->uid, time());
    $audit_report->runReport($audit_name);
  }

  return t('Processed audit: @name', array('@name' => $audit_name));
}

/**
 * Callback for processing all the audits.
 *
 * @return string
 *   The result of the audit processing.
 * @throws \Exception
 */
function audit_export_core_audit_process_all(): string {
  global $user;
  $audits = AuditExportAudit::getAudits();

  $audit_report = new AuditExportAuditReport($audits, [], $user->uid, time(), TRUE);
  $audit_report->runReport($audits);

  return t('Processed audit: @name', array('@name' => 'audit-name'));
}
