<?php

/**
 * Gather information about Rules configurations.
 */
class AuditExportRulesConfig extends AuditExportAuditData {

  public function __construct() {
    $this->setHeaders([
      'Rule Name',
      'Module',
      'Type',
      'Status',
      'Conditions',
      'Actions'
    ]);
  }

  public function prepareData(): array {
    $rules_data = [];
    if (module_exists('rules')) {
      $rules_data = rules_config_load_multiple(FALSE);
    }
    return array_keys($rules_data);
  }

  public function processData(array $params = []): array {
    $rule_id = $params["row_data"];
    $rule = rules_config_load($rule_id);

    // Process Events
    $events = array();
    if (method_exists($rule, 'events')) {
      foreach ($rule->events() as $event) {
        $events[] = rules_get_event_info($event)['label'];
      }
    }

    // Process Conditions
    $conditions = array();
    if (method_exists($rule, 'conditions')) {
      foreach ($rule->conditions() as $condition) {
        $conditions[] = $condition->label();
      }
    }

    // Process Actions
    $actions = array();
    if (method_exists($rule, 'actions')) {
      foreach ($rule->actions() as $action) {
        $actions[] = $action->label();
      }
    }

    return [
      $rule->label() . " ($rule_id)",
      $rule->module,
      ucwords($rule->getPluginName()),
      ($rule->active == '1') ? 'Enabled' : 'Disabled',
      implode(', ', $conditions),
      implode(', ', $actions)
    ];
  }

}
