<?php

/**
 * @file
 * Hooks provided by the Audit Export module.
 */

/**
 * Allows modules to define their own audit groups.
 *
 * An audit group is a collection of related audits. This hook allows modules to
 * register their own groups for organizing audits.
 *
 * @return array
 *   An associative array where the key is the group machine name and the value
 *   is an array with the following keys:
 *   - label: (required) The human-readable name of the group.
 *   - description: (required) A brief description of the group.
 */
function hook_aex_group(): array {
  // Define the audit export group
  return [
    'group_machine_name' => [
      'label' => t('Group Label'),
      'description' => t('Description of the group.')
    ]
  ];
}

/**
 * Defines audits to be performed.
 *
 * This hook allows modules to define audits that will be performed. Each audit
 * is an instance of a class that performs a specific check or series of checks
 * within the site, grouped by audit groups defined in hook_aex_group().
 *
 * @return array
 *   An associative array of audits, where the key is a unique identifier for
 *   the audit and the value is an array with the following keys:
 *   - name: (required) The machine name of the audit.
 *   - module: (required) The machine name of the module providing the audit.
 *   - identifier: (required) A unique identifier for instances of this audit.
 *   - label: (required) The human-readable name of the audit.
 *   - group: (required) The machine name of the group this audit belongs to.
 *   - dependencies: (optional) An array of module machine names that this
 *     audit depends on.
 *   - description: (required) A brief description of the audit.
 *   - className: (required) The name of the PHP class that performs the audit.
 */
function hook_aex_audit() {
  return [
    'enabled_blocks' => [
      'name' => 'enabled_blocks',
      'module' => 'module_name',
      'identifier' => 'id', // Manually specify the id to use when processing data @todo: Can this be removed?
      'label' => t('Name of Audit'),
      'group' => 'audit_group_name',
      'dependencies' => [],
      'description' => t('Description of what the audit does.'),
      'className' => 'CustomClass',
    ]
  ];
}

