<?php

/**
 * Implementation of hook_drush_help().
 */
function audit_export_core_drush_help($section) {
  if ($section == 'meta:audit_export_core:title') {
    return dt('Audit Export commands');
  }
}


/**
 * Implements hook_drush_command().
 */
function audit_export_core_drush_command() {
  $items = array();

  $items['audit-export-list'] = array(
    'description' => 'List all reports for Audit Export.',
    'aliases' => array('aexl'),
    'callback' => 'audit_export_core_drush_list_audits',
    'arguments' => array(
      'list' => 'A space delimited list of view names.',
    ),
  );

  $items['audit-export-process'] = array(
    'description' => 'List all reports for Audit Export.',
    'aliases' => array('aexp'),
    'callback' => 'audit_export_core_drush_process',
    'options' => array(
      'all' => 'Process all Audit reports.',
    ),
    'arguments' => array(
      'audit' => 'The id of the audit to process',
    )
  );

  $items['audit-export-env'] = array(
    'description' => 'Prints out the environment information for audit export.',
    'callback' => 'drush_audit_export_print_env',
  );

  return $items;
}

/**
 * Callback function for audit_export_hello Drush command.
 */
function audit_export_core_drush_list_audits() {
  $audits = AuditExportAudit::getAudits();

  // Define the headers for the table.
  $header = ['Audit', 'ID', 'Group', 'Description', 'Module', 'Dependencies'];

  // Convert rows to a format suitable for `drush_print_table()`.
  $table_rows = array();
  foreach ($audits as $audit) {
    $table_rows[] = array_values([
      'name' => $audit->label,
      'id' => $audit->name,
      'group' => $audit->group,
      'description' => $audit->description,
      'module' => $audit->module,
      'dependencies' => (!empty($audit->dependencies)) ?
        implode(', ', $audit->dependencies) :
        NULL,
    ]);
  }

  // Print all rows as a table.
  if (!empty($audits)) {
    array_unshift($table_rows, $header);
    drush_print_table($table_rows, TRUE);
  }

}

/**
 * Callback to process audits
 *
 * @throws \Exception
 */
function audit_export_core_drush_process($audit_id = NULL) {
  global $user;
  $audits = AuditExportAudit::getAudits();
  $options= [];

  if (empty($audit_id) && !drush_get_option('all')) {
    foreach ($audits as $audit_option) {
      $options[$audit_option->name] = $audit_option->label;
    }
    $audit_id = drush_choice($options, dt('Which report should be processed?'));
  }

  if (!empty($audit_id)) {
    $audit = $audits[$audit_id];
    if (class_exists($audit->className)) {
      $auditDataInstance = new $audit->className();
      $audit_report = new AuditExportAuditReport($audit, $auditDataInstance, $user->uid, time());
      $audit_report->runReport($audit_id, TRUE);
    }
  } elseif(drush_get_option('all')) {
    $audit_report = new AuditExportAuditReport($audits, [], $user->uid, time(), TRUE);
    $audit_report->runReport($audits, TRUE);
  }
}

/**
 * Callback function for the Drush command.
 */
function drush_audit_export_print_env() {
  drush_print('Environment Information:');
  drush_print('PHP Version: ' . phpversion());
  drush_print('Drupal Root: ' . DRUPAL_ROOT);
  drush_print('Site Path: ' . conf_path());
  // Add other critical environment information as needed.
}
