<?php

class AuditExportDisplay {

  /**
   * @var array
   */
  public $options;

  /**
   * @var array
   */
  public $header_rows;

  /**
   * @var array
   */
  public $data_rows;


  public function __construct($options, $header_rows, $data_rows) {
    $this->setHeaderRows($header_rows);
    $this->setDataRows($data_rows);
    $this->setOptions($options);
  }

  /**
   * @param $header_rows
   *
   * @return void
   */
  private function setHeaderRows($header_rows) {
    $this->header_rows = $header_rows;
  }

  private function setDataRows($data_rows) {
    $this->data_rows = $data_rows;
  }

  private function setOptions($options) {
    $this->options = $options;
  }

  /**
   * @throws \Exception
   */
  public static function renderDisplay($header_rows, $data_rows, $options = []) {

    drupal_add_css(drupal_get_path('module', 'audit_export') . '/css/audit_export.css');

    if (!empty($options['empty'])) {
      $empty = $options['empty'];
    }

    return theme('table',
      array(
        'header' => $header_rows,
        'rows' => $data_rows,
        'attributes' => ['class' => ['audit-export']],
        'empty' => ($empty ?? NULL),
      )
    );
  }

  /**
   * Replaces items in a nested array based on a defined replacement map.
   *
   * @param array $data The array containing nested arrays of items.
   * @param array $replacementMap The map defining what to search for and replace with.
   * @return array The modified array with items replaced according to the replacement map.
   */
  public static function tokenDisplayCleanup(array $data, array $replacementMap = []) {
    // Define the replacement map if not provided
    if (empty($replacementMap)) {
      $replacementMap = self::getReplacementMap();
    }

    // Iterate through the outer array
    foreach ($data as &$subArray) {
      if (is_array($subArray)) {
        // Iterate through the sub-array
        foreach ($subArray as $key => &$value) {
          // Check and replace substrings within the value
          if (is_string($value)) {
            $value = str_replace(array_keys($replacementMap), array_values($replacementMap), $value);
          }
        }
      }
    }

    return $data;
  }

  /**
   * Defines a key/value pair for searching and replacing items.
   *
   * @return array The replacement map.
   */
  public static function getReplacementMap() {
    return [
      // Define token replacements.
      '<front>' => '&lt;front&gt;',
    ];
  }

}
