# CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Configuration
- Maintainers

## Introduction

Auth Encrypt secures authentication credentials by encrypting sensitive form data on the client side and decrypting it on the server. It uses AES-256 encryption for login, registration, and user edit forms and now generates per-form, per-session keys embedded in each form; the server validates keys on submit and logs mismatches or decryption failures for better security and auditing.

## Requirements

- Drupal 10 or 11
- PHP OpenSSL extension
- CryptoJS library (via CDN or local installation)

## Installation

1. Install module as usual, see:
   <https://www.drupal.org/docs/extending-drupal/installing-modules>
2. No additional configuration needed - works out of the box
3. Optional: Add local CryptoJS library to `/libraries/crypto-js` if you want to avoid CDN usage

## Features

- Client-side encryption of authentication fields using CryptoJS
- Secure server-side decryption using OpenSSL
- Per-form, per-session encryption key management with server-side validation and detailed logging
- Zero configuration required
- Support for login, registration and user edit forms
- Flexible CryptoJS implementation (CDN/local)

## Maintainers

Current maintainers:

- [mesharideb] - <https://www.drupal.org/u/mesharideb>
