# Storage author module
### About
Content such as publications, citations and applications have a requirement to include their authors. This module provides an ability to manage authorship via a fieldable entity. All authors are centrally stored and are referenced by entities that include them.
It provides an ability to add Author fields to any content type bundle as a reference entity.

### Install modules
These below modules are used for configuring the storage author module as the entity reference in the content type and the storage type.

- [Storage Entities module](https://www.drupal.org/project/storage)
- [Inline Entity Form module](https://www.drupal.org/project/inline_entity_form)
- [Token module](https://www.drupal.org/project/token)
- [Organization Field Module](https://gitlab.hubzero.org/osp/drupal/organization_field.git)
- [Author Field Module](https://gitlab.hubzero.org/osp/drupal/author_field.git)

### Usecases
Three examples are suggested to create the storage entity with the author field and organization field modules.

- [Storage Author type](./usecases/usecase_author_storage_type.md)
- [Storage Author type with Organization field](./usecases/usecase_author_orgs_storage_type.md)
- [Storage Author type with Storage Organization type](./usecases/usecase_author_storage_type_org_storage_type.md)
