/**
 Implements the author field default user interface.

 This script facilitates tooltip functionality to display the organization name alongside each author,
 as well as controlling the toggling behavior of both the button and the content.
 */
(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.authorFieldTooltip = {
    attach: function (context, settings) {
      // Display the organization name alongside each author
      $(once('author-field-tooltip', $(".tooltip-trigger", context))).tooltip({
        position: { my: "left top+10", at: "left bottom" }
      });

      // Control the toggling behavior of both the button and the content
      $(once('toggleContent', $(".toggle-button", context))).click(function () {
        const $content = $(this).next('.content-to-toggle');
        $content.toggle();
        const newState = $content.is(':visible') ? 'visible' : 'hidden';
        $(this).attr('data-state', newState).text(newState === 'visible' ? 'Hide affiliations' : 'Show affiliations');
      });
    }
  };

})(jQuery, Drupal, drupalSettings);
